<%
'**************************************************************************************************************************
'Page: ParamVars.vb
'--------------------------------------------------------------------------------------------------------------------------
'Description:  Funciones para almacenar parametros de paso entre paginas en un XML
'--------------------------------------------------------------------------------------------------------------------------
'Referencias:	
'				../Includes/ServerFunctions.htm
'				Application("XMLQueryStringPath")
'--------------------------------------------------------------------------------------------------------------------------
'Author:        Ing. Ariel Schwindt
'Date:          03-Jul-2001
'LastModified:  03-Jul-2001
'**************************************************************************************************************************


'***************************************************************
' Inicializacion
'***************************************************************

Dim pstrXMLQueryString

pstrXMLQueryString=Request.QueryString("XMLQueryString")


'***************************************************************
' Scripts Servidor
'***************************************************************

'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Function AddParam(strXml, ParamId, ParamValue)
'**************************************************************************************************************************
'Procedure: AddParam
'--------------------------------------------------------------------------------------------------------------------------
'Description:  Agrega o modifica los parametros a ser usados en la pagina para los llamados posteriores.
'              Los parametros se almacenan en un XML
'--------------------------------------------------------------------------------------------------------------------------
'Parameters:
'               strXML              - Type: string - El contenido del XML
'               ParamId             - Type: string - El Id del Parametro
'               ParamValue          - Type: string - El Valor del Parametro
'--------------------------------------------------------------------------------------------------------------------------
'Return Type:	None
'--------------------------------------------------------------------------------------------------------------------------
'Author:        Ing. Ariel Schwindt
'Date:          03-Jul-2001
'LastModified:  03-Jul-2001
'**************************************************************************************************************************

            
    Dim oDom                'As MSXML2.DOMDocument30
    Dim oParameters         'As MSXML2.IXMLDOMNode
    Dim oParameter          'As MSXML2.IXMLDOMNode
    Dim oNodeId
    Dim oNodeValue
    Dim oNode
    
    If ParamValue="" then
		ParamValue="EMPTY"
	end if
    
    Set oDom = Server.CreateObject("MSXML2.DOMDocument")

    '- Crea los nodos con los valores para el Id y el Value
    '- en el Id crea un Cdata y en el value si es posible,
    '- lo carga en un nodo de Xml
    Set oNodeId = oDom.createCDATASection(ParamId)
    
    If oDom.loadXML(ParamValue) Then
        If oDom.hasChildNodes Then
            Set oNodeValue = oDom.documentElement.cloneNode(True)
        End If
    Else
        Set oNodeValue = oDom.createCDATASection(ParamValue)
    End If
            
    If Trim(strXml) = "" Then
                
        Set oDom = Server.CreateObject("MSXML2.DOMDocument")
        oDom.Load Application("XMLQueryStringPath")
        If oDom.parseError <> 0 Then
            Raiserror err.number,"ParamVars.htm - AddParam(1)" ,err.Description 
        End If
            
        Set oParameters = oDom.selectSingleNode("Prms")
        Set oParameter = oDom.selectSingleNode("Prms/Prm")

        '- agrega los valores al Xml de parametros
        '------------------------------------------------------------------------
            oParameter.selectSingleNode("Id").appendChild oNodeId
            oParameter.selectSingleNode("Val").appendChild oNodeValue
        '------------------------------------------------------------------------
        
        AddParam = oDom.xml
                
    Else
                
        Set oDom = Server.CreateObject("MSXML2.DOMDocument")
        if not oDom.loadXML (strXml) then
			raiserror err.number,"ParamVars.htm - AddParam(2)",err.Description 
        end if
                
        '- Obtiene los parametros
            Set oParameters = oDom.selectSingleNode("Prms")
        '- Busca el parametro con el q va a trabajar
            Set oParameter = oDom.selectSingleNode("Prms/Prm[Id='" & ParamId & "']")

        If oParameter Is Nothing Then
            Set oParameter = oParameters.firstChild.cloneNode(True)
        End If
        
        '- agrega los valores al Xml de parametros
        '------------------------------------------------------------------------
        For Each oNode In oParameter.selectSingleNode("Id").childNodes
            oParameter.selectSingleNode("Id").removeChild (oNode)
        Next
        For Each oNode In oParameter.selectSingleNode("Val").childNodes
            oParameter.selectSingleNode("Val").removeChild (oNode)
        Next
        oParameter.selectSingleNode("Id").appendChild oNodeId
        oParameter.selectSingleNode("Val").appendChild oNodeValue
        oParameters.appendChild oParameter
        '------------------------------------------------------------------------
                
        AddParam = oDom.xml

    End If
    
    '- garbage collector
    
    Set oDom = Nothing
    Set oParameters = Nothing
    Set oParameter = Nothing
    Set oNodeId = Nothing
    Set oNodeValue = Nothing
    Set oNode = Nothing
    
    
End Function

'///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Function DeleteParam(ParamId)
'**************************************************************************************************************************
'Procedure: DeleteParam
'--------------------------------------------------------------------------------------------------------------------------
'Description:  Elimina un parametro del XML de QueryString
'--------------------------------------------------------------------------------------------------------------------------
'Parameters:
'               strXML		        - Type: string - El contenido del XML
'				ParamId				- Type: string - El Id del Parametro
'--------------------------------------------------------------------------------------------------------------------------
'Return Type:	None
'--------------------------------------------------------------------------------------------------------------------------
'Author:        Ing. Ariel Schwindt
'Date:          02-Jul-2001
'LastModified:	02-Jul-2001
'**************************************************************************************************************************

    Dim oDom                'As MSXML2.DOMDocument
    Dim oParameters         'As MSXML2.IXMLDOMNode
    Dim oParameter          'As MSXML2.IXMLDOMNode
    Dim strXml
	
	strXml=pstrXMLQueryString
	
    Set oDom = Server.CreateObject("MSXML2.DOMDocument")
    if oDom.loadXML (strXml)=false then
		Raiserror err.number,"ParamVars.htm - DeleteParam",err.Description 
    end if
    
    Set oParameters = oDom.selectSingleNode("Prms")
    Set oParameter = oDom.selectSingleNode("Prms/Prm[Id='" & ParamId & "']")
        
    If Not oParameter Is Nothing Then 'El ParamId esta en el XML
        oParameters.removeChild oParameter
    End If
    
    DeleteParam = oDom.xml
    
    '- garbage collector
    Set oDom = Nothing
    Set oParameters = Nothing
    Set oParameter = Nothing

End Function

'///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Function GetParam(ParamId)
'**************************************************************************************************************************
'Procedure: GetParam
'--------------------------------------------------------------------------------------------------------------------------
'Description:  Devuelve el valor de un parametro
'--------------------------------------------------------------------------------------------------------------------------
'Parameters:
'               strXML		        - Type: string - El contenido del XML
'               ParamId             - Type: string - El Id del Parametro
'--------------------------------------------------------------------------------------------------------------------------
'Return Type:	String.
'--------------------------------------------------------------------------------------------------------------------------
'Author:        Ing. Ariel Schwindt
'Date:          03-Jul-2001
'LastModified:  03-Jul-2001
'**************************************************************************************************************************

            
    Dim oDom                'As MSXML2.DOMDocument
    Dim oParameter          'As MSXML2.IXMLDOMNode
	Dim strXml
	
	strXml=pstrXMLQueryString
	
    Set oDom = Server.CreateObject("MSXML2.DOMDocument")
    If oDom.loadXML(strXml) = False Then
        Raiserror err.number,"ParamVars.htm - GetParam",err.Description 
    End If
    
    Set oParameter = oDom.selectSingleNode("Prms/Prm[Id='" & ParamId & "']")

    If Not oParameter Is Nothing Then 'El ParamId esta en el XML
        GetParam = oParameter.selectSingleNode("Val").Text
        Set oDom = Server.CreateObject("MSXML2.DOMDocument")
        
        If oParameter.selectSingleNode("Val").hasChildNodes Then
        
            If oDom.loadXML(oParameter.selectSingleNode("Val").firstChild.xml) Then
                GetParam = oParameter.selectSingleNode("Val").firstChild.xml
            End If
        
        End If
        
    End If
    
    '- garbage collector
    Set oDom = Nothing
    Set oParameter = Nothing

End Function

'///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Function AddQueryString()
'**************************************************************************************************************************
'Procedure: AddQueryString
'--------------------------------------------------------------------------------------------------------------------------
'Description:  Arma el Parametro de pase entre paginas
'--------------------------------------------------------------------------------------------------------------------------
'Return Type:	String.
'--------------------------------------------------------------------------------------------------------------------------
'Author:        Ing. Ariel Schwindt
'Date:          03-Jul-2001
'LastModified:	03-Jul-2001
'**************************************************************************************************************************

	AddQueryString="?XMLQueryString=" & Server.urlEncode(pstrXMLQueryString)
	
End Function	

'///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

'***************************************************************
' Includes de Scripts Servidor
'***************************************************************

%>
<!--#INCLUDE FILE="../Includes/ErrorFunctions.vb"-->